/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.capability.TridentSlotCapability;
import fuzs.bettertridents.data.ModItemModelProvider;
import fuzs.bettertridents.data.ModLanguageProvider;
import fuzs.bettertridents.data.ModRecipeProvider;
import fuzs.bettertridents.handler.LoyalDropsHandler;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CoreServices;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="bettertridents")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterTridentsForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("bettertridents").accept(new BetterTridents());
        BetterTridentsForge.registerCapabilities();
        BetterTridentsForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.TRIDENT_SLOT_CAPABILITY, (CapabilityToken)new CapabilityToken<TridentSlotCapability>(){});
    }

    private static void registerHandlers() {
        LoyalDropsHandler loyalDropsHandler = new LoyalDropsHandler();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, evt -> loyalDropsHandler.onLivingDrops(evt.getEntity(), evt.getSource(), evt.getDrops(), evt.getLootingLevel(), evt.isRecentlyHit()).ifPresent(unit -> evt.setCanceled(true)));
        MinecraftForge.EVENT_BUS.addListener(evt -> loyalDropsHandler.onLivingExperienceDrop(evt.getEntity(), evt.getAttackingPlayer(), evt.getOriginalExperience(), evt.getDroppedExperience()).ifPresent(i -> {
            if (i > 0) {
                evt.setDroppedExperience(i);
            } else {
                evt.setCanceled(true);
            }
        }));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModRecipeProvider(generator, "bettertridents"));
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "bettertridents"));
        generator.m_236039_(true, (DataProvider)new ModItemModelProvider(generator, "bettertridents", existingFileHelper));
    }
}

